/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAttribute;
import org.python.indexer.ast.NCall;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NName
extends NNode {
    static final long serialVersionUID = -1160862551327528304L;
    public final String id;

    public NName(String string) {
        this(string, 0, 1);
    }

    public NName(String string, int n, int n2) {
        super(n, n2);
        if (string == null) {
            throw new IllegalArgumentException("'id' param cannot be null");
        }
        this.id = string;
    }

    public NType resolve(Scope scope) throws Exception {
        NBinding nBinding = scope.lookup(this.id);
        if (nBinding == null) {
            nBinding = this.makeTempBinding(scope);
        }
        Indexer.idx.putLocation(this, nBinding);
        return this.setType(nBinding.followType());
    }

    public boolean isCall() {
        NNode nNode;
        if (this.parent != null && this.parent.isCall() && this == ((NCall)this.parent).func) {
            return true;
        }
        return this.parent instanceof NAttribute && this == ((NAttribute)this.parent).attr && (nNode = this.parent.parent) instanceof NCall && this.parent == ((NCall)nNode).func;
    }

    private NBinding makeTempBinding(Scope scope) {
        Scope scope2 = scope.getScopeSymtab();
        NBinding nBinding = scope2.put(this.id, this, new NUnknownType(), NBinding.Kind.SCOPE);
        this.setType(nBinding.getType().follow());
        this.getTable().setPath(scope2.extendPath(this.id));
        return nBinding;
    }

    public boolean isAttribute() {
        return this.parent instanceof NAttribute && ((NAttribute)this.parent).getAttr() == this;
    }

    public String toString() {
        return "<Name:" + this.start() + ":" + this.id + ">";
    }

    public void visit(NNodeVisitor nNodeVisitor) {
        nNodeVisitor.visit(this);
    }
}

